﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.Links;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using System.Diagnostics;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{
    public class SendToEcStep : FilterBase<GetConsultsForPatientStateObject>
    {

        public override void Execute(GetConsultsForPatientStateObject state)
        {
            //Also add the fake failure as an option for the fake EcResponse depending on the value (usually we do 0 is success or 1 is failure)
            if (!string.IsNullOrEmpty(state.ConsultsFakeResponseType))
            {
                var fakeEcResponse = VistaFakeResponses.FakeGetConsultsForPatientSuccess();
                if (state.PatEcRequest != null)
                    state.PatEcResponse = fakeEcResponse;
                if (state.ProEcRequest != null)
                    state.ProEcResponse = fakeEcResponse;
            }
            else
            {
                try
                {
                    var requestKvps = new List<KeyValuePair<string, VIMTVIAEMRgcfpgetConsultsForPatientRequest>>();
                    requestKvps.Add(new KeyValuePair<string, VIMTVIAEMRgcfpgetConsultsForPatientRequest>("Pat", state.PatEcRequest));
                    requestKvps.Add(new KeyValuePair<string, VIMTVIAEMRgcfpgetConsultsForPatientRequest>("Pro", state.ProEcRequest));

                    var timer = new Stopwatch();
                    timer.Start();
                    Parallel.ForEach(requestKvps, request =>
                    {
                        if (request.Key == "Pat" && state.PatEcRequest != null)
                            state.PatEcResponse = state.PatEcRequest.SendReceive<VIMTVIAEMRgcfpgetConsultsForPatientResponse>(MessageProcessType.Local);
                        if (request.Key == "Pro" && state.ProEcRequest != null)
                            state.ProEcResponse = state.ProEcRequest.SendReceive<VIMTVIAEMRgcfpgetConsultsForPatientResponse>(MessageProcessType.Local);
                    });
                    timer.Stop();
                    state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;
                }
                catch (Exception ex)
                {
                    state.ExceptionOccured = true;
                    state.ExceptionMessage = PipelineUtilities.BuildErrorMessage(ex);
                }
            }
        }
    }
}
